package org.amse.mm.myVirtualBilliards.model.impl;

import org.amse.mm.myVirtualBilliards.model.*;

public class Cue implements ICue{
	private double myAngle = -Math.PI / 2;
	private double myForce = 0;
	
	public void doStrike(ITable table, double angle, double force){
		IBall ball = null;
		for (IBall tmpBall : table.balls()){
			if (tmpBall.getColor() == BallColor.WHITE){
				ball = tmpBall;
				break;
			}
		}
		
		if (ball == null){
			throw new RuntimeException("Can't find WHITE ball");
		}else{
			ball.setVelocity(force * Math.cos(angle), force * Math.sin(angle));
		}	
	}
	
	public void doStrike(ITable table){
		IBall ball = null;
		for (IBall tmpBall : table.balls()){
			if (tmpBall.getColor() == BallColor.WHITE){
				ball = tmpBall;
				break;
			}
		}
		
		if (ball == null){
			throw new RuntimeException("Can't find WHITE ball");
		}else{
			ball.setVelocity(myForce * Math.cos(myAngle), myForce * Math.sin(myAngle));
		}	
	}
	
	public double getAngle(){
		return myAngle;
	}
	
	public void setAngle(double angle){
		myAngle = angle;
	}
	
	public double getForce(){
		return myForce;
	}
	
	public void setForce(double force){
		myForce = force;
	}
	
	

}
